(*********************************************
TExplosion->TSprite

A simple sprite class that renders a particle
based explosive effect.
*********************************************)

unit Explosion;

interface

uses
  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls, TurboSprite;

type

  TExplBits = record
     pt: TPoint;
     x, y: integer;
  end;

  TExplosion = class( TSprite )
  private
     FLife: integer;
     FCol: byte;
     arParticles: array[1..12] of TExplBits;
  protected
  public
     constructor CreateExplosion( MoveProc: TMoveProc; pt: TPoint; nLife: integer; nColor: byte );
     procedure Move; override;
     procedure Render; override;
  end;

implementation

constructor TExplosion.CreateExplosion( MoveProc: TMoveProc; pt: TPoint; nLife: integer; nColor: byte );
var
  i: integer;
begin
  inherited Create( MoveProc );
  FCol := nColor;
  FLife := nLife;
  Position := pt;
  for i := 1 to 12 do
     with arParticles[i] do
        begin
           pt.X := Position.X;
           pt.Y := Position.Y;
           x := Random( 200 );
           if Random( 100 ) > 50 then
              x := -x;
           y := Random( 200 );
           if Random( 100 ) > 50 then
              y := -y;
        end;
end;

procedure TExplosion.Move;
begin
  inherited Move;
  if FLife > 0 then
     begin
        Dec( FLife );
        if FLife = 0 then
           Dead := true;
     end;
end;

procedure TExplosion.Render;
var
  i: integer;
  x_, y_: integer;
begin
  inherited Render;
  for i := 1 to 12 do
     with arParticles[i] do
        begin
           if Random( 200 ) > Abs( x ) then
              if x < 0 then
                 Dec( pt.X )
              else
                 Inc( pt.X );
           if Random( 200 ) > Abs( y ) then
              if y < 0 then
                 Dec( pt.Y )
              else
                 Inc( pt.Y );
           if ( pt.X >= 0 ) and ( pt.X < SpriteSurface.DIBCanvas.Width - 2 ) and
              ( pt.Y >= 0 ) and ( pt.Y < SpriteSurface.DIBCanvas.Height - 2 ) then
              begin
                with SpriteSurface.DIBCanvas do
                begin
                  Pixels[pt.X, pt.Y] := Random( 16 ) + FCol;
                  Pixels[pt.X + 1, pt.Y] := Random( 16 ) + FCol;
                  Pixels[pt.X, pt.Y + 1] := Random( 16 ) + FCol;
                  Pixels[pt.X + 1, pt.Y + 1] := Random( 16 ) + FCol;
                end;
              end;
        end;
end;

end.
